import os
import pandas as pd
from datasets import Dataset
from pathlib import Path

csv_dir = Path("results/subsets")

def push_csv_to_hf(csv_file, repo_name):
    name = csv_file.split(".")[0]
    print(f"Processing {name}...")

    df = pd.read_csv(csv_dir / csv_file)

    if "messages" in df.columns:
        df["messages"] = df["messages"].apply(eval)

    dataset = Dataset.from_pandas(df)
    dataset.push_to_hub(
        repo_name,
        config_name=name,
        split="test",
        private=True
    )
    print(f"Successfully pushed {name} to the hub!")

files = [
    'alpaca.csv',
    'insider-trading.csv',
    'soft-trigger.csv',
    'harm-pressure-choice.csv',
    'harm-pressure-knowledge-report.csv',
    'instructed-deception.csv',
    'convincing-game.csv',
    'gender-secret.csv'
]

# Call for all datasets in liars-bench
for csv_file in files:
    push_csv_to_hf(csv_file, "XYZ-XXXX-3/liars-bench")

# Push mask.csv to mask-generations
push_csv_to_hf('mask.csv', "XYZ-XXXX-3/mask-generations")